<?php
// ডাটাবেস সংযোগ
require 'admin/db_config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // ইনপুট ডাটা গ্রহণ ও স্যানিটাইজ করা (Security)
    $clientName = mysqli_real_escape_string($conn, $_POST['clientName']);
    $mobileNumber = mysqli_real_escape_string($conn, $_POST['mobileNumber']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);
    $websiteName = mysqli_real_escape_string($conn, $_POST['websiteName']);
    $requirementDemo = mysqli_real_escape_string($conn, $_POST['requirementDemo']);
    $projectStartDate = mysqli_real_escape_string($conn, $_POST['projectStartDate']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $paymentMethod = mysqli_real_escape_string($conn, $_POST['payment_method']);

    // লোগো আপলোড হ্যান্ডলিং
    $logo_path = "";
    if (isset($_FILES['websiteLogoUpload']) && $_FILES['websiteLogoUpload']['error'] == 0) {
        $target_dir = "uploads/";
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        $file_name = time() . '_' . basename($_FILES["websiteLogoUpload"]["name"]);
        $target_file = $target_dir . $file_name;
        
        if (move_uploaded_file($_FILES["websiteLogoUpload"]["tmp_name"], $target_file)) {
            $logo_path = $target_file;
        }
    }

    // ডাটাবেসে ডাটা ইনসার্ট করা (Prepared Statement ব্যবহার করা হয়েছে সিকিউরিটির জন্য)
    $sql = "INSERT INTO orders (client_name, mobile_number, email, address, website_name, requirement_demo, project_start_date, logo_path, description, payment_method) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "ssssssssss", $clientName, $mobileNumber, $email, $address, $websiteName, $requirementDemo, $projectStartDate, $logo_path, $description, $paymentMethod);

    if (mysqli_stmt_execute($stmt)) {
        echo "<script>
                alert('আপনার অর্ডারটি সফলভাবে জমা হয়েছে!');
                window.location.href='index.php';
              </script>";
    } else {
        echo "Error: " . mysqli_error($conn);
    }

    mysqli_stmt_close($stmt);
    mysqli_close($conn);
}
?>