<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>প্রজেক্ট ইনভয়েস - CodexioBD</title>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #ff4d6d;
            --bg: #f3f4f9;
            --card-bg: #ffffff;
            --text: #333;
        }

        body {
            font-family: 'Hind Siliguri', sans-serif;
            background-color: var(--bg);
            margin: 0;
            padding: 20px;
            color: var(--text);
        }

        .invoice-box {
            max-width: 850px;
            margin: auto;
            padding: 40px;
            border-radius: 20px;
            background: var(--card-bg);
            box-shadow: 0 10px 30px rgba(0,0,0,0.05);
            border: 1px solid #eee;
        }

        /* Header Section */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid var(--bg);
            padding-bottom: 20px;
            margin-bottom: 30px;
        }

        .logo {
            font-size: 28px;
            font-weight: 700;
        }

        .logo span { color: var(--primary); }

        .invoice-title {
            text-align: right;
        }

        .invoice-title h2 {
            margin: 0;
            color: var(--primary);
            font-size: 24px;
        }

        /* Info Grid */
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 40px;
            margin-bottom: 40px;
        }

        .info-section h4 {
            margin-bottom: 10px;
            color: #777;
            text-transform: uppercase;
            font-size: 14px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }

        .info-section p {
            margin: 5px 0;
            line-height: 1.6;
        }

        /* Table Style */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        table th {
            background: var(--bg);
            text-align: left;
            padding: 12px;
            border-radius: 5px;
        }

        table td {
            padding: 15px 12px;
            border-bottom: 1px solid #eee;
        }

        .text-right { text-align: right; }

        /* Total Section */
        .total-section {
            float: right;
            width: 300px;
        }

        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
        }

        .grand-total {
            font-size: 20px;
            font-weight: 700;
            color: var(--primary);
            border-top: 2px solid var(--primary);
            margin-top: 10px;
            padding-top: 10px;
        }

        /* Buttons */
        .no-print {
            text-align: center;
            margin-top: 30px;
        }

        .btn {
            padding: 10px 25px;
            border-radius: 10px;
            text-decoration: none;
            color: white;
            background: var(--primary);
            border: none;
            cursor: pointer;
            font-size: 16px;
            transition: 0.3s;
        }

        .btn-secondary {
            background: #555;
            margin-right: 10px;
        }

        /* Mobile Responsive */
        @media (max-width: 600px) {
            .header, .info-grid {
                flex-direction: column;
                grid-template-columns: 1fr;
                text-align: center;
            }
            .invoice-title, .total-section {
                text-align: center;
                float: none;
                width: 100%;
            }
            .invoice-box { padding: 20px; }
        }

        /* Print Style */
        @media print {
            .no-print { display: none; }
            body { background: white; padding: 0; }
            .invoice-box { box-shadow: none; border: none; }
        }
    </style>
</head>
<body>

<?php
// ফর্ম থেকে আসা ডাটা রিসিভ করা (যদি থাকে)
// সিকিউরিটির জন্য htmlspecialchars ব্যবহার করা হয়েছে
$client_name = isset($_POST['client_name']) ? htmlspecialchars($_POST['client_name']) : "মো: আব্দুল্লাহ";
$mobile      = isset($_POST['mobile']) ? htmlspecialchars($_POST['mobile']) : "০১৭XXXXXXXX";
$email       = isset($_POST['email']) ? htmlspecialchars($_POST['email']) : "client@example.com";
$address     = isset($_POST['address']) ? htmlspecialchars($_POST['address']) : "ঢাকা, বাংলাদেশ";
$site_name   = isset($_POST['site_name']) ? htmlspecialchars($_POST['site_name']) : "ই-কমার্স ওয়েবসাইট";
$order_date  = isset($_POST['start_date']) ? htmlspecialchars($_POST['start_date']) : date("d-m-Y");
$invoice_id  = "INV-" . rand(1000, 9999);
?>

<div class="invoice-box">
    <!-- Header -->
    <div class="header">
        <div class="logo">CODEXIO<span>BD</span></div>
        <div class="invoice-title">
            <h2>অর্ডার ইনভয়েস</h2>
            <p>আইডি: <?php echo $invoice_id; ?><br>তারিখ: <?php echo $order_date; ?></p>
        </div>
    </div>

    <!-- Info Section -->
    <div class="info-grid">
        <div class="info-section">
            <h4>বিল প্রেরক:</h4>
            <strong>CodexioBD Digital Agency</strong><br>
            মিরপুর, ঢাকা - ১২১৬<br>
            ফোন: +৮৮০ ১২৩৪ ৫৬৭৮৯০<br>
            ইমেইল: info@codexiobd.com
        </div>
        <div class="info-section">
            <h4>বিল প্রাপক:</h4>
            <strong><?php echo $client_name; ?></strong><br>
            <?php echo $address; ?><br>
            ফোন: <?php echo $mobile; ?><br>
            ইমেইল: <?php echo $email; ?>
        </div>
    </div>

    <!-- Table Details -->
    <table>
        <thead>
            <tr>
                <th>প্রজেক্টের বিবরণ</th>
                <th class="text-right">পরিমাণ</th>
                <th class="text-right">মূল্য (৳)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <strong><?php echo $site_name; ?></strong><br>
                    <small>রেসপনসিভ এবং সিকিউর ওয়েব ডেভেলপমেন্ট</small>
                </td>
                <td class="text-right">০১</td>
                <td class="text-right">১০,০০০.০০</td>
            </tr>
        </tbody>
    </table>

    <!-- Total Amount -->
    <div class="total-section">
        <div class="total-row">
            <span>সাব-টোটাল:</span>
            <span>১০,০০০.০০ ৳</span>
        </div>
        <div class="total-row">
            <span>ডিসকাউন্ট:</span>
            <span>০.০০ ৳</span>
        </div>
        <div class="total-row grand-total">
            <span>মোট বিল:</span>
            <span>১০,০০০.০০ ৳</span>
        </div>
    </div>
    
    <div style="clear: both;"></div>

    <!-- Footer Note -->
    <div style="margin-top: 50px; border-top: 1px solid #eee; padding-top: 20px; font-size: 13px; color: #777;">
        <p><strong>নোট:</strong> আমাদের ওপর আস্থা রাখার জন্য ধন্যবাদ। প্রজেক্টের কাজ আগামী ৩০ কার্যদিবসের মধ্যে সম্পন্ন করা হবে।</p>
    </div>
</div>

<!-- Print/Download Button -->
<div class="no-print">
    <button onclick="window.print()" class="btn btn-secondary">PDF ডাউনলোড করুন</button>
    <a href="#" class="btn">হোমে ফিরে যান</a>
</div>

</body>
</html>