<?php
ob_start();
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include 'db_config.php';

if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: mobile_purchases_list.php");
    exit();
}

$id = mysqli_real_escape_string($conn, $_GET['id']);
$query = "SELECT * FROM mobile_purchases WHERE id = '$id'";
$result = mysqli_query($conn, $query);
$data = mysqli_fetch_assoc($result);

if (!$data) {
    die("Error: No data found in database!");
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <link rel="icon" type="image/jpeg" href="https://cdn3d.iconscout.com/3d/premium/thumb/html-3d-icon-png-download-12760849.png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cash Memo - #MW-<?php echo $data['id']; ?></title>
    
    <!-- Google Fonts for Proper Bengali Rendering -->
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- PDF Library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    
    <style>
        :root { 
            --primary: #1e3a8a; 
            --accent: #2563eb; 
            --bg: #f3f4f6; 
            --white: #ffffff; 
            --text-dark: #1f2937;
        }
        
        body { 
            font-family: 'Hind Siliguri', sans-serif; /* Bengali Friendly Font */
            background: var(--bg); 
            margin: 0; 
            display: flex; 
            flex-direction: column; 
            min-height: 100vh;
            color: var(--text-dark);
        }
        
        .sidebar-wrapper { width: 250px; position: fixed; height: 100vh; z-index: 1000; transition: 0.3s; }
        .main-content { margin-left: 250px; width: calc(100% - 250px); flex-grow: 1; transition: 0.3s; display: flex; flex-direction: column; }
        .page-content { padding: 20px; }

        .toolbar { 
            background: var(--white); 
            padding: 15px 25px; 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1); 
            margin-bottom: 20px; 
            border-radius: 12px; 
        }
        .btn-action { padding: 8px 18px; border-radius: 8px; border: none; cursor: pointer; font-weight: bold; text-decoration: none; display: inline-flex; align-items: center; gap: 8px; font-size: 14px; transition: 0.3s; }
        .btn-pdf { background: #e11d48; color: white; }
        .btn-print { background: #059669; color: white; }
        .btn-back { background: #4b5563; color: white; }

        /* --- Cash Memo Design (Standard Size) --- */
        #invoice-wrapper { overflow-x: auto; padding-bottom: 30px; }
        
        #invoice {
            width: 794px; 
            min-height: 650px;
            margin: 0 auto;
            background: #fff;
            padding: 40px 50px;
            box-sizing: border-box;
            position: relative;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1); 
            border-top: 10px solid var(--primary); 
            letter-spacing: 0px; /* বাংলার জন্য ০ রাখা জরুরি */
        }

        .memo-header { 
            display: flex; 
            justify-content: space-between; 
            border-bottom: 2px solid #e5e7eb; 
            padding-bottom: 12px; 
            align-items: flex-start; 
        }
        .shop-brand { flex: 2; }
        .shop-brand h1 { 
            margin: 0; 
            font-size: 32px; 
            color: var(--primary); 
            font-weight: 700; 
            white-space: nowrap; 
        }
        .shop-brand p { margin: 3px 0 0 0; font-size: 15px; color: var(--accent); font-weight: 600; }
        
        .shop-contact { 
            flex: 1;
            text-align: right; 
            font-size: 13px; 
            line-height: 1.5; 
            color: #374151; 
            margin-top: 25px; 
        }
        .shop-contact strong { font-size: 17px; color: #111827; display: block; }

        .memo-title-box { text-align: center; margin: 20px 0; }
        .memo-title-box span { background: var(--primary); color: #fff; padding: 6px 35px; border-radius: 50px; font-weight: bold; font-size: 13px; }

        .top-info { display: flex; justify-content: space-between; margin-bottom: 20px; }
        .cus-box { width: 65%; }
        .cus-box p { margin: 8px 0; border-bottom: 1px dashed #d1d5db; padding-bottom: 4px; font-size: 14px; }
        .cus-box strong { width: 100px; display: inline-block; color: #374151; }

        .memo-meta { text-align: right; width: 30%; }
        .seller-img { width: 90px; height: 105px; border: 2px solid #fff; border-radius: 8px; object-fit: cover; margin-bottom: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }

        table.memo-table { width: 100%; border-collapse: collapse; margin-top: 5px; }
        table.memo-table th { background: #f1f5f9; border: 1px solid #e2e8f0; padding: 10px; text-align: left; font-size: 13px; color: var(--primary); }
        table.memo-table td { border: 1px solid #e2e8f0; padding: 12px 10px; vertical-align: top; font-size: 14px; line-height: 1.6; }

        .memo-footer { margin-top: 20px; display: flex; justify-content: space-between; align-items: flex-start; }
        .ref-info { width: 52%; font-size: 12px; color: #4b5563; background: #f8fafc; padding: 12px; border-radius: 8px; border: 1px solid #e2e8f0; }
        .memo-calc { width: 260px; }
        .calc-row { display: flex; justify-content: space-between; padding: 6px 0; border-bottom: 1px solid #f1f5f9; font-size: 14px; }
        .total-row { background: #fef2f2; border-top: 2px solid #ef4444; padding: 10px 8px; font-weight: 700; font-size: 18px; color: #b91c1c; margin-top: 8px; border-radius: 4px; }

        .terms-box { margin-top: 25px; font-size: 11px; color: #6b7280; border-top: 1px solid #f1f5f9; padding-top: 15px; line-height: 1.6; }
        .sig-container { display: flex; justify-content: space-between; margin-top: 70px; }
        .sig-box { border-top: 2px solid #1f2937; width: 190px; text-align: center; padding-top: 8px; font-size: 13px; font-weight: bold; position: relative; }
        .signature-img { position: absolute; top: -65px; left: 50%; transform: translateX(-50%); max-width: 140px; max-height: 70px; object-fit: contain; }

        @media (max-width: 768px) {
            .sidebar-wrapper { left: -250px; }
            .main-content { margin-left: 0; width: 100%; }
            #invoice { width: 794px; }
        }

        @media print {
            .sidebar-wrapper, .toolbar, .top-header-area { display: none !important; }
            .main-content { margin-left: 0 !important; width: 100% !important; }
            body { background: white; }
            #invoice { box-shadow: none; border: none; padding: 10px; width: 100%; min-height: auto; }
        }
    </style>
</head>
<body>

    <div class="sidebar-wrapper">
        <?php include 'sidebar.php'; ?>
    </div>

    <div class="main-content">
        <div class="top-header-area">
            <?php include 'top_header.php'; ?>
        </div>

        <div class="page-content">
            <div class="toolbar">
                <a href="mobile_purchases_list.php" class="btn-action btn-back"><i class="fas fa-arrow-left"></i> লিস্টে ফিরে যান</a>
                <div style="display:flex; gap:12px;">
                    <button onclick="downloadPDF()" class="btn-action btn-pdf"><i class="fas fa-file-pdf"></i> PDF ডাউনলোড</button>
                    <button onclick="window.print()" class="btn-action btn-print"><i class="fas fa-print"></i> প্রিন্ট মেমো</button>
                </div>
            </div>

            <div id="invoice-wrapper">
                <div id="invoice">
                    <div class="memo-header">
                        <div class="shop-brand">
                            <h1>বিসমিল্লাহ্‌ মোবাইল হসপিটাল</h1>
                            <p>অনুপম সুপার মার্কেট, চান্দনা চৌরাস্তা, গাজীপুর।</p>
                        </div>
                        <div class="shop-contact">
                            <strong>আল-আমিন আহমেদ</strong>
                            মোবাইল: 01912-855989 <br>
                            ইমেইল: info@mobilehospital.com
                        </div>
                    </div>

                    <div class="memo-title-box">
                        <span>CASH MEMO / ইনভয়েস</span>
                    </div>

                    <div class="top-info">
                        <div class="cus-box">
                            <p><strong>বিক্রেতার নাম:</strong> <?php echo $data['seller_name']; ?></p>
                            <p><strong>মোবাইল:</strong> <?php echo $data['seller_phone']; ?></p>
                            <p><strong>NID নম্বর:</strong> <?php echo $data['seller_nid']; ?></p>
                        </div>
                        <div class="memo-meta">
                            <?php if(!empty($data['seller_photo'])): ?>
                                <img src="<?php echo $data['seller_photo']; ?>" class="seller-img">
                            <?php endif; ?>
                            <div style="font-size: 13px;">
                                <strong>মেমো নং:</strong> #MW-<?php echo 1000 + $data['id']; ?><br>
                                <strong>তারিখ:</strong> <?php echo date('d/m/Y', strtotime($data['created_at'])); ?>
                            </div>
                        </div>
                    </div>

                    <table class="memo-table">
                        <thead>
                            <tr>
                                <th width="10%" style="text-align:center;">ক্র.নং</th>
                                <th width="65%">বিবরণ (Device Info & Condition)</th>
                                <th width="25%" style="text-align:right;">ক্রয়মূল্য (টাকা)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style="text-align:center; font-weight:bold;">০১</td>
                                <td>
                                    <strong>মডেল:</strong> <?php echo $data['model']; ?> (<?php echo $data['storage']; ?>)<br>
                                    <strong>IMEI ১:</strong> <?php echo $data['imei1']; ?> 
                                    <?php if(!empty($data['imei2'])) echo " | <strong>IMEI ২:</strong> ".$data['imei2']; ?><br>
                                    <strong>কালার:</strong> <?php echo $data['color']; ?> | <strong>ব্যাটারি হেলথ:</strong> <?php echo $data['battery']; ?>%<br>
                                    <strong>কন্ডিশন:</strong> <?php echo $data['check_list']; ?>
                                </td>
                                <td style="text-align:right; font-weight:bold; font-size:16px;">
                                    <?php echo number_format($data['buying_price'], 2); ?>
                                </td>
                            </tr>
                            <tr style="height: 40px;">
                                <td></td><td></td><td></td>
                            </tr>
                        </tbody>
                    </table>

                    <div class="memo-footer">
                        <div class="ref-info">
                            <h4 style="margin: 0 0 8px 0; color: var(--primary); font-size: 14px;">নিরাপত্তা রেফারেন্স:</h4>
                            পরিবারের মোবাইল: <?php echo $data['ref_phone']; ?><br>
                            রেফারেন্স NID: <?php echo $data['ref_nid']; ?><br>
                            পেমেন্ট: <?php echo $data['payment_method']; ?>
                        </div>

                        <div class="memo-calc">
                            <div class="calc-row"><span>মোট মূল্য:</span><span style="font-weight:bold;"><?php echo number_format($data['buying_price'], 2); ?></span></div>
                            <div class="calc-row"><span>ডিসকাউন্ট:</span>- ০.০০</div>
                            <div class="calc-row total-row"><span>সর্বমোট প্রদান:</span><span><?php echo number_format($data['buying_price'], 2); ?></span></div>
                        </div>
                    </div>

                    <div class="terms-box">
                        <strong>শর্তাবলী:</strong><br>
                        ১. বিক্রেতা ঘোষণা করছেন যে এই ফোনের মালিক তিনি নিজে এবং এটি কোনো অবৈধ উৎস থেকে প্রাপ্ত নয়।<br>
                        ২. ফোনের আইনী কোনো সমস্যা দেখা দিলে তার পূর্ণ দায়ভার বিক্রেতার।<br>
                        ৩. কোনো সফটওয়্যার বা হার্ডওয়্যার লক থাকলে বিক্রেতা তা আনলক করে দিতে বাধ্য।<br>
                        ৪. ভবিষ্যতে আইনী জটিলতায় এই মেমোটি প্রমাণ হিসেবে ব্যবহৃত হবে।
                    </div>

                    <div class="sig-container">
                        <div class="sig-box">ক্রেতার স্বাক্ষর</div>
                        <div class="sig-box">
                            <?php if(!empty($data['signature'])): ?>
                                <img src="<?php echo $data['signature']; ?>" class="signature-img">
                            <?php endif; ?>
                            বিক্রেতার স্বাক্ষর
                        </div>
                    </div>
                </div>
            </div> 
        </div>
    </div>

    <script>
        function downloadPDF() {
            const element = document.getElementById('invoice');
            const options = {
                margin: 0,
                filename: 'CashMemo_MW_<?php echo $data['id']; ?>.pdf',
                image: { type: 'jpeg', quality: 1 },
                html2canvas: { 
                    scale: 3, 
                    useCORS: true, 
                    logging: false,
                    letterRendering: false // এটি বাংলায় গোল চিহ্ন আসা বন্ধ করে
                },
                jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
            };
            html2pdf().set(options).from(element).save();
        }
    </script>
</body>
</html>
<?php ob_end_flush(); ?>