<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$lang = isset($_SESSION['admin_lang']) ? $_SESSION['admin_lang'] : 'bn';

$side_words = [
    'bn' => [
        'dashboard' => 'ড্যাশবোর্ড',
        'orders' => 'অর্ডার সমূহ',
        'mobile_info' => 'মোবাইল ইনফো',
        'mobile_list' => 'মোবাইল ক্রয় লিস্ট',
        'dukan_vara' => 'দোকান ভাড়া',
        'team' => 'টিম মেম্বার',
        'demo' => 'ডেমো / প্রোডাক্টস',
        'services' => 'সার্ভিস সমূহ',
        'work' => 'রিসেন্ট ওয়ার্ক',
        'notice' => 'নোটিশ বোর্ড',
        'settings' => 'ওয়েবসাইট সেটিংস',
        'logout' => 'লগআউট',
        'logout_confirm' => 'লগআউট করতে চান?'
    ],
    'en' => [
        'dashboard' => 'Dashboard',
        'orders' => 'Orders List',
        'mobile_info' => 'Mobile Info',
        'mobile_list' => 'Purchase List',
        'dukan_vara' => 'Shop Rent',
        'team' => 'Team Members',
        'demo' => 'Demos / Products',
        'services' => 'Our Services',
        'work' => 'Recent Works',
        'notice' => 'Notice Board',
        'settings' => 'Site Settings',
        'logout' => 'Logout',
        'logout_confirm' => 'Do you want to logout?'
    ]
];

$st = $side_words[$lang];
$current_page = basename($_SERVER['PHP_SELF']);
?>

<style>
    :root {
        --sidebar-width: 260px;
        --sidebar-bg: #2c3e50;
    }

    /* সাইডবার বেসিক ডিজাইন */
    .sidebar { 
        width: var(--sidebar-width); 
        background: var(--sidebar-bg); 
        color: #fff; 
        position: fixed; 
        height: 100vh; 
        left: 0; 
        top: 0; 
        transition: all 0.3s ease; 
        z-index: 1100; 
        overflow-y: auto;
    }

    .sidebar-header { 
        padding: 20px; 
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: #1a252f; 
        border-bottom: 1px solid rgba(255,255,255,0.1); 
    }

    .sidebar-header h3 { font-size: 18px; margin: 0; color: #fff; }

    /* ক্লোজ বাটন - শুধুমাত্র মোবাইলে দেখাবে */
    .close-sidebar {
        display: none; /* ডেক্সটপে লুকানো */
        background: none;
        border: none;
        color: #fff;
        font-size: 24px;
        cursor: pointer;
    }

    .sidebar-menu { list-style: none; padding: 10px 0; margin: 0; }
    .sidebar-menu li a { 
        display: flex; 
        align-items: center; 
        padding: 12px 20px; 
        color: #bdc3c7; 
        text-decoration: none; 
        transition: 0.2s;
        border-left: 4px solid transparent;
    }

    .sidebar-menu li a i { width: 25px; margin-right: 10px; text-align: center; }
    .sidebar-menu li a:hover, .sidebar-menu li a.active { 
        background: rgba(0,0,0,0.2); 
        color: #fff; 
        border-left: 4px solid #3498db; 
    }

    /* ডেক্সটপ ভিউতে কন্টেন্টকে জায়গা দেয়া */
    @media (min-width: 992px) {
        .content-wrapper { margin-left: var(--sidebar-width); }
    }

    /* মোবাইল রেসপনসিভনেস */
    @media (max-width: 991px) {
        .sidebar { left: -100%; } /* মোবাইলে প্রথমে হাইড থাকবে */
        .sidebar.active { left: 0; }
        .close-sidebar { display: block; } /* মোবাইলে ক্লোজ বাটন দেখাবে */
        
        /* মোবাইল ওভারলে */
        .sidebar-overlay {
            display: none;
            position: fixed;
            width: 100%; height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 1050;
            top: 0; left: 0;
        }
        .sidebar-overlay.show { display: block; }
    }
</style>

<!-- মোবাইল ওভারলে -->
<div class="sidebar-overlay" id="overlay" onclick="toggleSidebar()"></div>

<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <h3>WebDev Admin</h3>
        <!-- Close Icon -->
        <button class="close-sidebar" onclick="toggleSidebar()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    
    <ul class="sidebar-menu">
        <?php
        $menu_items = [
            ['dashboard.php', 'fas fa-tachometer-alt', 'dashboard'],
            ['orders_manage.php', 'fas fa-shopping-cart', 'orders'],
            ['mobile_info_manage.php', 'fas fa-mobile-alt', 'mobile_info'],
            ['mobile_purchases_list.php', 'fas fa-list-ul', 'mobile_list'],
            ['dukan_vara_manage.php', 'fas fa-store', 'dukan_vara'],
            ['team_manage.php', 'fas fa-users', 'team'],
            ['demo_manage.php', 'fas fa-desktop', 'demo'],
            ['services.php', 'fas fa-briefcase', 'services'],
            ['recent_work_manage.php', 'fas fa-images', 'work'],
            ['notice_manage.php', 'fas fa-bullhorn', 'notice'],
            ['settings.php', 'fas fa-cog', 'settings'],
        ];

        foreach ($menu_items as $item) {
            $active = ($current_page == $item[0]) ? 'active' : '';
            echo "<li><a href='{$item[0]}' class='{$active}'><i class='{$item[1]}'></i> {$st[$item[2]]}</a></li>";
        }
        ?>
        <li style="margin-top: 10px; border-top: 1px solid rgba(255,255,255,0.1);">
            <a href="logout.php" style="color: #e74c3c;" onclick="return confirm('<?php echo $st['logout_confirm']; ?>')">
                <i class="fas fa-sign-out-alt"></i> <?php echo $st['logout']; ?>
            </a>
        </li>
    </ul>
</aside>

<script>
    // সাইডবার খোলা বা বন্ধ করার ফাংশন
    function toggleSidebar() {
        document.getElementById('sidebar').classList.toggle('active');
        document.getElementById('overlay').classList.toggle('show');
    }
</script>