<?php
session_start();
require_once 'db_config.php';

// লগইন চেক
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("location: login.php");
    exit;
}

// বর্তমান ভাষা নির্ধারণ (top_header.php এর সেশন অনুযায়ী)
$lang = isset($_SESSION['admin_lang']) ? $_SESSION['admin_lang'] : 'bn';

// নোটিশ পেজের জন্য অনুবাদ
$notice_words = [
    'bn' => [
        'page_title' => 'নোটিশ ম্যানেজমেন্ট - অ্যাডমিন প্যানেল',
        'top_title' => 'নোটিশ বোর্ড ম্যানেজমেন্ট',
        'add_new' => '+ নতুন নোটিশ লিখুন',
        'update_info' => 'নোটিশ আপডেট করুন',
        'notice_text' => 'নোটিশ টেক্সট',
        'placeholder' => 'এখানে নোটিশ লিখুন...',
        'publish' => 'পাবলিশ করুন',
        'update' => 'আপডেট করুন',
        'cancel' => 'ক্যান্সেল',
        'th_notice' => 'নোটিশ',
        'th_status' => 'স্ট্যাটাস',
        'th_action' => 'অ্যাকশন',
        'active' => 'Active',
        'hidden' => 'Hidden',
        'confirm_delete' => 'আপনি কি নিশ্চিত যে এটি ডিলিট করবেন?',
        'msg_add' => 'নতুন নোটিশ যুক্ত হয়েছে!',
        'msg_update' => 'নোটিশ আপডেট হয়েছে!',
        'msg_delete' => 'নোটিশ ডিলিট হয়েছে!',
        'no_data' => 'কোনো নোটিশ নেই'
    ],
    'en' => [
        'page_title' => 'Notice Management - Admin Panel',
        'top_title' => 'Notice Board Management',
        'add_new' => '+ Write New Notice',
        'update_info' => 'Update Notice',
        'notice_text' => 'Notice Text',
        'placeholder' => 'Write notice here...',
        'publish' => 'Publish Now',
        'update' => 'Update Now',
        'cancel' => 'Cancel',
        'th_notice' => 'Notice',
        'th_status' => 'Status',
        'th_action' => 'Action',
        'active' => 'Active',
        'hidden' => 'Hidden',
        'confirm_delete' => 'Are you sure you want to delete this?',
        'msg_add' => 'New notice added successfully!',
        'msg_update' => 'Notice updated successfully!',
        'msg_delete' => 'Notice deleted successfully!',
        'no_data' => 'No notices found'
    ]
];
$t = $notice_words[$lang];

// ================= PHP লজিক শুরু ================= //

// ১. নোটিশ সেভ বা আপডেট
if (isset($_POST['save_notice'])) {
    $id = $_POST['notice_id'];
    $text = mysqli_real_escape_string($conn, $_POST['notice_text']);

    if ($id) {
        $sql = "UPDATE notices SET notice_text='$text' WHERE id=$id";
        $msg = $t['msg_update'];
    } else {
        $sql = "INSERT INTO notices (notice_text, status) VALUES ('$text', 1)";
        $msg = $t['msg_add'];
    }
    
    if(mysqli_query($conn, $sql)){
        echo "<script>alert('$msg'); window.location.href='notice_manage.php';</script>";
    } else {
        echo "<script>alert('Error: " . mysqli_error($conn) . "');</script>";
    }
}

// ২. স্ট্যাটাস টগল
if (isset($_GET['toggle_status'])) {
    $id = intval($_GET['toggle_status']);
    mysqli_query($conn, "UPDATE notices SET status = 1 - status WHERE id=$id");
    echo "<script>window.location.href='notice_manage.php';</script>";
}

// ৩. ডিলিট করা
if (isset($_GET['delete_notice'])) {
    $id = intval($_GET['delete_notice']);
    mysqli_query($conn, "DELETE FROM notices WHERE id=$id");
    echo "<script>alert('".$t['msg_delete']."'); window.location.href='notice_manage.php';</script>";
}

// ৪. এডিট ডাটা ফেচ
$edit_data = null;
if (isset($_GET['edit_notice'])) {
    $id = intval($_GET['edit_notice']);
    $res = mysqli_query($conn, "SELECT * FROM notices WHERE id=$id");
    $edit_data = mysqli_fetch_assoc($res);
}
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $t['page_title']; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root { --primary: #2c3e50; --accent: #3498db; --bg: #f4f6f9; }
        * { margin:0; padding:0; box-sizing:border-box; font-family:'Segoe UI', sans-serif; }
        body { background: var(--bg); display:flex; min-height:100vh; }
        
        .main-content { margin-left:250px; width:calc(100% - 250px); transition: 0.3s; min-height: 100vh; }
        .content-body { padding: 30px; }

        /* ব্যাজ ও বাটন */
        .status-badge { padding: 5px 10px; border-radius: 20px; font-size: 0.8rem; color: #fff; font-weight: bold; }
        .status-active { background: #27ae60; }
        .status-inactive { background: #e74c3c; }

        .action-btn { padding: 6px 10px; border-radius: 4px; color: #fff; text-decoration: none; font-size: 0.85rem; margin-right: 5px; display: inline-block; }
        .btn-edit { background: #f39c12; } .btn-hide { background: #34495e; } .btn-show { background: #27ae60; } .btn-delete { background: #c0392b; }

        /* ফর্ম */
        .form-container { background: #fff; padding: 25px; border-radius: 8px; margin-bottom: 30px; border-left: 5px solid var(--accent); box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        .form-control { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; margin-bottom: 15px; font-size: 15px; }
        .submit-btn { background: var(--accent); color: #fff; padding: 10px 25px; border: none; cursor: pointer; border-radius: 4px; font-size: 1rem; font-weight: 600; }

        /* টেবিল */
        table { width: 100%; border-collapse: collapse; background: #fff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        th, td { padding: 15px; border-bottom: 1px solid #eee; text-align: left; vertical-align: middle; }
        th { background: #f8f9fa; color: var(--primary); }

        @media(max-width:768px){ .main-content{margin-left:0; width:100%;} }
    </style>
</head>
<body>

    <!-- ১. সাইডবার ইনক্লুড -->
    <?php include 'sidebar.php'; ?>

    <main class="main-content">
        
        <!-- ২. গ্লোবাল টপ হেডার ইনক্লুড -->
        <?php include 'top_header.php'; ?>

        <div class="content-body">
            <!-- অ্যাড / এডিট ফর্ম -->
            <div class="form-container">
                <h4><?php echo $edit_data ? $t['update_info'] : $t['add_new']; ?></h4>
                <br>
                <form method="POST">
                    <input type="hidden" name="notice_id" value="<?php echo $edit_data['id'] ?? ''; ?>">

                    <label style="font-weight:600; display:block; margin-bottom:8px;"><?php echo $t['notice_text']; ?></label>
                    <textarea name="notice_text" class="form-control" rows="4" required placeholder="<?php echo $t['placeholder']; ?>"><?php echo $edit_data['notice_text'] ?? ''; ?></textarea>
                    
                    <button type="submit" name="save_notice" class="submit-btn">
                        <?php echo $edit_data ? $t['update'] : $t['publish']; ?>
                    </button>
                    
                    <?php if($edit_data): ?>
                        <a href="notice_manage.php" style="margin-left:10px; color:red; text-decoration:none; font-weight:600;"><?php echo $t['cancel']; ?></a>
                    <?php endif; ?>
                </form>
            </div>

            <!-- লিস্ট টেবিল -->
            <div style="overflow-x:auto;">
                <table>
                    <thead>
                        <tr>
                            <th style="width: 60%;"><?php echo $t['th_notice']; ?></th>
                            <th><?php echo $t['th_status']; ?></th>
                            <th><?php echo $t['th_action']; ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $res = mysqli_query($conn, "SELECT * FROM notices ORDER BY id DESC");
                        if(mysqli_num_rows($res) > 0) {
                            while($row = mysqli_fetch_assoc($res)){
                                $status = isset($row['status']) ? $row['status'] : 1;
                                $status_text = ($status == 1) ? $t['active'] : $t['hidden'];
                                $status_class = ($status == 1) ? 'status-active' : 'status-inactive';
                        ?>
                            <tr>
                                <td style="line-height: 1.4;"><?php echo htmlspecialchars($row['notice_text']); ?></td>
                                <td><span class="status-badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span></td>
                                <td>
                                    <a href="notice_manage.php?edit_notice=<?php echo $row['id']; ?>" class="action-btn btn-edit"><i class="fas fa-edit"></i></a>
                                    
                                    <a href="notice_manage.php?toggle_status=<?php echo $row['id']; ?>" class="action-btn <?php echo ($status == 1) ? 'btn-hide' : 'btn-show'; ?>">
                                        <?php if($status == 1): ?><i class="fas fa-eye-slash"></i><?php else: ?><i class="fas fa-eye"></i><?php endif; ?>
                                    </a>
                                    
                                    <a href="notice_manage.php?delete_notice=<?php echo $row['id']; ?>" class="action-btn btn-delete" onclick="return confirm('<?php echo $t['confirm_delete']; ?>')"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php } } else { ?>
                            <tr><td colspan="3" style="text-align:center; padding:20px; color:#666;"><?php echo $t['no_data']; ?></td></tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</body>
</html>