<?php
include 'db_config.php';

// ডিলিট লজিক
if (isset($_GET['delete_id'])) {
    $id = $_GET['delete_id'];
    mysqli_query($conn, "DELETE FROM mobile_purchases WHERE id = $id");
    header("Location: mobile_purchases_list.php");
}

$query = "SELECT * FROM mobile_purchases ORDER BY id DESC";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
        <link rel="icon" type="image/jpeg" href="https://cdn3d.iconscout.com/3d/premium/thumb/html-3d-icon-png-download-12760849.png">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mobile Buy List - Admin</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root { --primary: #2563eb; --bg: #f3f4f6; }
        body { font-family: 'Segoe UI', Tahoma, sans-serif; background: var(--bg); margin: 0; display: flex; }
        
        .sidebar-wrapper { width: 250px; flex-shrink: 0; }
        .content-area { flex-grow: 1; padding: 25px; width: calc(100% - 250px); }

        .list-card { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; border-bottom: 2px solid #eee; padding-bottom: 10px; }
        
        /* Table Style */
        .table-responsive { overflow-x: auto; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 14px; }
        table th, table td { padding: 12px 15px; border: 1px solid #e5e7eb; text-align: left; }
        table th { background: #f8fafc; color: #475569; font-weight: 600; }
        table tr:hover { background: #f9fafb; }

        .badge { padding: 4px 8px; border-radius: 4px; font-size: 12px; font-weight: bold; }
        .price { color: #b91c1c; font-weight: bold; }
        
        .action-btns { display: flex; gap: 8px; }
        .btn-view { color: #2563eb; cursor: pointer; }
        .btn-delete { color: #ef4444; cursor: pointer; text-decoration: none; }

        .seller-img { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 1px solid #ddd; }

        @media (max-width: 768px) {
            body { flex-direction: column; }
            .sidebar-wrapper { width: 100%; }
            .content-area { width: 100%; padding: 15px; }
        }
    </style>
</head>
<body>

    <div class="sidebar-wrapper">
        <?php include 'sidebar.php'; ?>
    </div>

    <div class="content-area">
        <div class="list-card">
            <div class="header">
                <h2 style="color:var(--primary); margin:0;"><i class="fas fa-list-ul"></i> মোবাইল ক্রয় লিস্ট</h2>
                <a href="mobile_info_manage.php" style="background:var(--primary); color:#fff; padding:8px 15px; text-decoration:none; border-radius:6px; font-size:14px;">+ নতুন ক্রয়</a>
            </div>

            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>ছবি</th>
                            <th>বিক্রেতার নাম</th>
                            <th>মোবাইল মডেল</th>
                            <th>IMEI (১)</th>
                            <th>ক্রয়মূল্য</th>
                            <th>পেমেন্ট</th>
                            <th>তারিখ</th>
                            <th>অ্যাকশন</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td>
                                <?php if($row['seller_photo']): ?>
                                    <img src="<?php echo $row['seller_photo']; ?>" class="seller-img">
                                <?php else: ?>
                                    <i class="fas fa-user-circle fa-2x" style="color:#ccc"></i>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong><?php echo $row['seller_name']; ?></strong><br>
                                <small style="color:#666"><?php echo $row['seller_phone']; ?></small>
                            </td>
                            <td><?php echo $row['model']; ?></td>
                            <td><?php echo $row['imei1']; ?></td>
                            <td class="price"><?php echo number_format($row['buying_price'], 2); ?> ৳</td>
                            <td><span class="badge" style="background:#eef2ff; color:#4338ca;"><?php echo $row['payment_method']; ?></span></td>
                            <td><?php echo date('d M, Y', strtotime($row['created_at'])); ?></td>
                            <td class="action-btns">
                                <a href="view_mobile_details.php?id=<?php echo $row['id']; ?>" class="btn-view" title="দেখুন"><i class="fas fa-eye"></i></a>
                                <a href="mobile_purchases_list.php?delete_id=<?php echo $row['id']; ?>" class="btn-delete" onclick="return confirm('আপনি কি নিশ্চিত যে এটি ডিলিট করতে চান?')" title="ডিলিট"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                        
                        <?php if(mysqli_num_rows($result) == 0): ?>
                        <tr>
                            <td colspan="8" style="text-align:center; padding:20px; color:#991b1b;">কোনো তথ্য পাওয়া যায়নি!</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</body>
</html>