<?php
session_start();
include 'db_config.php'; // ডেটাবেস কানেকশন ফাইল যুক্ত করা হলো

if(isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true){
     header("location: dashboard.php");
    exit;
}

$error = '';

if($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = $_POST['password'];

    // ডেটাবেস থেকে ইউজার খোঁজা
    $sql = "SELECT * FROM admins WHERE username = '$username'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        // পাসওয়ার্ড ভেরিফাই করা (এখন আমরা প্লেইন টেক্সট 12345 চেক করছি না, হ্যাশ চেক করছি)
        // কিন্তু শুরুতে সহজ করার জন্য SQL ফাইলে আমি প্লেইন পাসওয়ার্ড রাখার অপশন দিচ্ছি না, 
        // আপনি যদি '12345' দিয়ে ঢুকতে চান তবে নিচের if কন্ডিশনটি ব্যবহার করুন:
        
        // নোট: আমি SQL ফাইলে '12345' এর হ্যাশ দিয়েছি, তাই password_verify কাজ করবে।
        if (password_verify($password, $row['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_id'] = $row['id'];
            header("location: admin.php");
            exit;
        } else {
            $error = "পাসওয়ার্ড ভুল হয়েছে!";
        }
    } else {
        $error = "ইউজারনেম পাওয়া যায়নি!";
    }
}
?>

<!-- HTML অংশ আগের মতই থাকবে -->
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>অ্যাডমিন লগইন</title>
    <!-- আগের CSS স্টাইল এখানে থাকবে -->
    <style>
        /* আপনার আগের CSS কোড */
        body { background-color: #f4f6f9; display: flex; justify-content: center; align-items: center; height: 100vh; font-family: sans-serif; }
        .login-card { background: #fff; padding: 40px; border-radius: 10px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); width: 350px; text-align: center; }
        input { width: 100%; padding: 10px; margin: 10px 0; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box;}
        button { width: 100%; padding: 10px; background: #3498db; color: white; border: none; border-radius: 5px; cursor: pointer; }
        .error { color: red; margin-bottom: 10px; display: block; }
    </style>
</head>
<body>
    <div class="login-card">
        <h2>লগইন</h2>
        <?php if($error) echo "<span class='error'>$error</span>"; ?>
        <form method="POST">
            <input type="text" name="username" placeholder="Username" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>