<?php
session_start();
require_once 'db_config.php';

// লগইন চেক
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("location: login.php");
    exit;
}

// আইডি গেট করা
if (!isset($_GET['id'])) {
    die("অর্ডার আইডি পাওয়া যায়নি।");
}

$id = $_GET['id'];

// ডাটাবেস থেকে অর্ডারের বিস্তারিত আনা
$stmt = $conn->prepare("SELECT * FROM orders WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$order = $result->fetch_assoc();

if (!$order) {
    die("কোনো তথ্য পাওয়া যায়নি।");
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ইনভয়েস - #<?php echo $order['id']; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        :root { --primary: #ff4d6d; --text: #334155; --light: #f8fafc; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Hind Siliguri', sans-serif; }
        body { background: #f1f5f9; padding: 40px 20px; color: var(--text); }

        .invoice-card {
            background: #fff;
            max-width: 850px;
            margin: 0 auto;
            padding: 50px;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.05);
            position: relative;
        }

        /* হেডার */
        .invoice-header { display: flex; justify-content: space-between; align-items: center; border-bottom: 2px solid #f1f5f9; padding-bottom: 30px; margin-bottom: 30px; }
        .logo { font-size: 28px; font-weight: 800; color: #1e293b; text-decoration: none; }
        .logo span { color: var(--primary); }
        .invoice-label { text-align: right; }
        .invoice-label h2 { color: var(--primary); font-size: 24px; text-transform: uppercase; letter-spacing: 1px; }

        /* ইনফো গ্রিড */
        .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 40px; margin-bottom: 40px; }
        .info-box h4 { font-size: 14px; text-transform: uppercase; color: #94a3b8; margin-bottom: 10px; border-bottom: 1px solid #f1f5f9; padding-bottom: 5px; }
        .info-box p { line-height: 1.6; font-size: 15px; }

        /* টেবিল */
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        table th { background: var(--light); text-align: left; padding: 15px; font-size: 14px; color: #64748b; }
        table td { padding: 15px; border-bottom: 1px solid #f1f5f9; }
        .text-right { text-align: right; }

        /* পেমেন্ট সামারি */
        .summary-container { display: flex; justify-content: space-between; align-items: flex-start; }
        .payment-status { background: #f0fdf4; border: 1px dashed #22c55e; padding: 20px; border-radius: 12px; width: 45%; }
        .payment-status h5 { color: #166534; margin-bottom: 10px; font-size: 16px; }
        .payment-status p { font-size: 13px; color: #166534; opacity: 0.8; }

        .calculation { width: 40%; }
        .calc-row { display: flex; justify-content: space-between; padding: 8px 0; }
        .calc-row.total { border-top: 2px solid var(--primary); margin-top: 10px; padding-top: 15px; font-weight: 700; font-size: 18px; color: var(--primary); }

        /* বাটন */
        .actions { text-align: center; margin-top: 40px; }
        .btn { padding: 12px 25px; border-radius: 10px; border: none; cursor: pointer; font-weight: 600; text-decoration: none; display: inline-block; transition: 0.3s; }
        .btn-print { background: var(--primary); color: #fff; box-shadow: 0 5px 15px rgba(255, 77, 109, 0.3); }
        .btn-back { background: #64748b; color: #fff; margin-right: 10px; }
        .btn:hover { transform: translateY(-2px); opacity: 0.9; }

        /* লোগো প্রিভিউ (যদি থাকে) */
        .client-logo { width: 100px; height: 100px; object-fit: contain; margin-bottom: 10px; background: #f8fafc; border: 1px solid #eee; padding: 5px; border-radius: 10px; }

        @media print {
            body { background: #fff; padding: 0; }
            .invoice-card { box-shadow: none; border: none; width: 100%; max-width: 100%; padding: 20px; }
            .actions { display: none; }
        }

        @media (max-width: 600px) {
            .info-grid { grid-template-columns: 1fr; gap: 20px; }
            .summary-container { flex-direction: column; }
            .payment-status, .calculation { width: 100%; }
            .calculation { margin-top: 30px; }
        }
    </style>
</head>
<body>

<div class="invoice-card">
    <!-- Header -->
    <div class="invoice-header">
        <a href="#" class="logo">CODEXIO<span>BD</span></a>
        <div class="invoice-label">
            <h2>অর্ডার ইনভয়েস</h2>
            <p>আইডি: #<?php echo $order['id']; ?></p>
            <small>অর্ডার তারিখ: <?php echo date('d M, Y', strtotime($order['created_at'])); ?></small>
        </div>
    </div>

    <!-- Info Grid -->
    <div class="info-grid">
        <div class="info-box">
            <h4>বিল প্রেরক:</h4>
            <p><strong>CodexioBD Digital Agency</strong><br>
            মিরপুর, ঢাকা - ১২১৬<br>
            ফোন: +৮৮০ ১২৩৪ ৫৬৭৮৯০<br>
            ইমেইল: info@codexiobd.com</p>
        </div>
        <div class="info-box">
            <h4>বিল প্রাপক:</h4>
            <p><strong><?php echo htmlspecialchars($order['client_name']); ?></strong><br>
            <?php echo htmlspecialchars($order['address']); ?><br>
            ফোন: <?php echo htmlspecialchars($order['mobile_number']); ?><br>
            ইমেইল: <?php echo htmlspecialchars($order['email']); ?></p>
        </div>
    </div>

    <!-- Project Details Table -->
    <table>
        <thead>
            <tr>
                <th>প্রজেক্টের বিবরণ</th>
                <th>শুরুর তারিখ</th>
                <th>সম্পন্ন তারিখ</th>
                <th class="text-right">পরিমাণ</th>
                <th class="text-right">মূল্য (৳)</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <strong><?php echo htmlspecialchars($order['website_name']); ?></strong><br>
                    <small><?php echo nl2br(htmlspecialchars($order['description'])); ?></small>
                    <?php if($order['logo_path']): ?>
                        <div style="margin-top:10px;">
                            <small>লোগো ফাইল:</small><br>
                            <img src="../<?php echo $order['logo_path']; ?>" class="client-logo">
                        </div>
                    <?php endif; ?>
                </td>
                <td><?php echo date('d M, Y', strtotime($order['project_start_date'])); ?></td>
                <td><?php echo date('d M, Y', strtotime($order['project_end_date'])); ?></td>
                <td>০১</td>
                <td class="text-right"><?php echo number_format($order['total_price'], 2); ?></td>
            </tr>
        </tbody>
    </table>

    <!-- Summary -->
    <div class="summary-container">
        <div class="payment-status">
            <h5>পেমেন্ট ডিটেইলস</h5>
            <p><strong>মেথড:</strong> <?php echo htmlspecialchars($order['payment_method']); ?></p>
            <p><strong>প্রেরক নম্বর:</strong> <?php echo htmlspecialchars($order['sender_number']); ?></p>
            <p><strong>Transaction ID:</strong> <?php echo htmlspecialchars($order['transaction_id']); ?></p>
            <p><strong>স্ট্যাটাস:</strong> <?php echo $order['status']; ?></p>
        </div>

        <div class="calculation">
            <div class="calc-row">
                <span>সাব-টোটাল:</span>
                <span><?php echo number_format($order['total_price'], 2); ?> ৳</span>
            </div>
            <div class="calc-row">
                <span>অগ্রিম পরিশোধিত:</span>
                <span>- <?php echo number_format($order['advance_payment'], 2); ?> ৳</span>
            </div>
            <div class="calc-row total">
                <span>বকেয়া/বাকি:</span>
                <span><?php echo number_format($order['due_amount'], 2); ?> ৳</span>
            </div>
        </div>
    </div>

    <div style="margin-top: 50px; border-top: 1px solid #f1f5f9; padding-top: 20px; font-size: 12px; color: #94a3b8; text-align: center;">
        <p>এটি একটি কম্পিউটার জেনারেটেড ইনভয়েস, কোনো স্বাক্ষরের প্রয়োজন নেই। আমাদের সাথে থাকার জন্য ধন্যবাদ।</p>
    </div>
</div>

<!-- Actions -->
<div class="actions">
    <a href="orders_manage.php" class="btn btn-back">অর্ডার লিস্টে ফিরুন</a>
    <button onclick="window.print()" class="btn btn-print">ডাউনলোড / প্রিন্ট করুন</button>
</div>

</body>
</html>